/*
*  Arnold emulator (c) Copyright, Kevin Thacker 1995-2015
*
*  This file is part of the Arnold emulator source code distribution.
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/* TODO - hook in flash */
#include "cpc.h"
#include "emudevice.h"

typedef struct
{
	BOOL Rom0Enabled;
	BOOL Rom7Enabled;
	int RomSelect;
	unsigned char Rom[512 * 1024];
	ExpansionRomData m_Roms;
} Megaflash;

static Megaflash flash;

// TODO
void Megaflash_ClearExpansionRom(int RomIndex)
{
	
}

// TODO
BOOL Megaflash_SetExpansionRom(int RomIndex, const unsigned char *pData, unsigned long Length)
{
	return TRUE;
}


void Megaflash_InitDevice(void)
{
	int i;

	flash.Rom0Enabled = FALSE;
	flash.Rom7Enabled = FALSE;
	flash.RomSelect = 0;

	/* find actual initialised value. Any value other than 0 should be ok including ff*/
	memset(flash.Rom, 0x01, sizeof(flash.Rom));

	// TODO
	ExpansionRom_Init(&flash.m_Roms, Megaflash_ClearExpansionRom, Megaflash_SetExpansionRom);

	for (i = 0; i < 32; i++)
	{
		ExpansionRom_SetAvailableState(&flash.m_Roms, i, TRUE);
	}
}


BOOL Megaflash_GetRom0Switch(void)
{
	return flash.Rom0Enabled;
}

void Megaflash_SetRom0Switch(BOOL bState)
{
	flash.Rom0Enabled= bState;
}


BOOL Megaflash_GetRom7Switch(void)
{
	return flash.Rom7Enabled;
}

void Megaflash_SetRom7Switch(BOOL bState)
{
	flash.Rom7Enabled = bState;
}

void Megaflash_MemoryRethink(MemoryData *pData)
{
	if (
		(flash.Rom0Enabled&& (flash.RomSelect==0)) ||
		(flash.Rom7Enabled && (flash.RomSelect==7)) ||
		((flash.RomSelect!=0) && (flash.RomSelect!=7) && (flash.RomSelect<32))
		)
		{
		const unsigned char *pROMData = ExpansionRom_GetSafe(&flash.m_Roms, flash.RomSelect) - 0x0c000;
		/* uses ROMEN */
		if (pData->bRomEnable[6] && !pData->bRomDisable[6])
		{
			pData->bRomDisable[6] = TRUE;
			pData->pReadPtr[6] = pROMData;
			pData->pReadMaskPtr[6] = GetDefaultReadMask() - 0x0c000;
		}
		if (pData->bRomEnable[7] && !pData->bRomDisable[7])
		{
			pData->bRomDisable[7] = TRUE;
			pData->pReadPtr[7] = pROMData;
			pData->pReadMaskPtr[7] = GetDefaultReadMask() - 0x0c000;
		}
	}
}


void	Megaflash_ROM_Write(Z80_WORD Port, Z80_BYTE Data)
{
	flash.RomSelect = Data;
	
    Computer_RethinkMemory();	
}


void Megaflash_Reset(void)
{
}


CPCPortWrite MegaflashPortWrite[1] =
{
	{
		0x02000,            /* and */
		0x00000,            /* compare */
		Megaflash_ROM_Write
	}
};



static EmuDeviceSwitch MegaflashSwitches[2] =
{
	{
		"J0 (On=ROM 0 from Megaflash, Off=Do not override Rom 0)",
		"Rom0Switch",
		Megaflash_GetRom0Switch,
		Megaflash_SetRom0Switch
	},
	{
		"J7 (On=ROM 7 from Megaflasg, Off=Do not override Rom 7)",
		"Rom7Switch",
		Megaflash_GetRom7Switch,
		Megaflash_SetRom7Switch
	},
};


static EmuDevice MegaflashDevice=
{
	NULL,
	Megaflash_InitDevice,
	NULL,
	"Megaflash",
	"Megaflash",
	"Bryce's Megaflash",
    CONNECTION_EXPANSION,   /* connects to expansion */
	DEVICE_FLAGS_HAS_DKTRONICS_RAM,                   
    0,                /* no read ports */
  NULL,
  sizeof(MegaflashPortWrite)/sizeof(MegaflashPortWrite[0]),                    /* 1 write ports */
  MegaflashPortWrite,
  0,                /* no memory read*/
  NULL,
  0,                /* no memory write */
  NULL,
  Megaflash_Reset, /* no reset function */
  Megaflash_MemoryRethink, /* no rethink function */
  Megaflash_Reset, /* no power function */
	sizeof(MegaflashSwitches)/sizeof(MegaflashSwitches[0]),                      /* no switches */
	MegaflashSwitches,
    0,                      /* no buttons */
    NULL,
    0,                      /* no onboard roms */
    NULL,
	NULL,	/* no cursor update function */
	0,
	NULL,
	&flash.m_Roms, /* rom slots */
	NULL,	/* printer */
	NULL, /* joystick */
	  0,
	  NULL,
	  NULL, /* sound */
	  NULL, /* lpen */
	  NULL, /* reti */
	  NULL, /* ack maskable interrupt */
	  NULL, /* dkram data */
	  NULL, /* device ram */
	  NULL, /* device backup */
	  NULL
};

int Megaflash_Init(void)
{
	return RegisterDevice(&MegaflashDevice);
}











